<?php
header('Content-Type: application/json');
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once 'conn.php';
include 'ida.php';

function GeraHash($qtd){ 

    $Caracteres = '0123456789'; 
    $QuantidadeCaracteres = strlen($Caracteres); 
    $QuantidadeCaracteres--; 
    
    $Hash=NULL; 
        for($x=1;$x<=$qtd;$x++){ 
            $Posicao = rand(0,$QuantidadeCaracteres); 
            $Hash .= substr($Caracteres,$Posicao,1); 
        } 
    
    return $Hash; 
}


try {
    // Capturar los datos enviados
    $data = json_decode(file_get_contents('php://input'), true);

    if (!$data) {
        throw new Exception('Datos no recibidos o inválidos.');
    }

    // Asignar los datos a variables
    $agencia = $data['agencia'] ?? '';
    $folio = $data['folio'] ?? '';
    $name = $data['name'] ?? '';
    $email = $data['email'] ?? '';
    $phone = $data['phone'] ?? '';
    $pax = $data['pax'] ?? '';
    $car = $data['car'] ?? '';
    $pagado = $data['pagado'] ?? '';
    $total = $data['total'] ?? '';
    $pickupPlace = $data['pickupPlace'] ?? '';
    $activity = $data['activity'] ?? '';
    $activityDate = $data['activityDate'] ?? '';
    $activityTime = $data['activityTime'] ?? '';
    $bbs = $data['bbs'] ?? '';
    $crs = $data['crs'] ?? '';
    $bos = $data['bos'] ?? '';
    $shopping = $data['shopping'] ?? 0;
    $obs_int = $data['obs_int'] ?? '';
    $service =  'act';
    $balance = $total - $pagado;
    $idr = GeraHash(7);
    $proveedor_id = 1;

    // Validar campos obligatorios


    // Preparar la consulta SQL
    $sql = "INSERT INTO reservas (
        agencia, folio, name, email, phone, pax, car, pagado, total, balance, arrival_pickup, 
        arrival_hotel, arrival_date, arrival_time, babyseat, carseat, boosterseat, shopping, obs_int, service, ida, idr, proveedor_id
    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

    $stmt = $conn->prepare($sql);

    if (!$stmt) {
        throw new Exception('Error al preparar la consulta SQL.');
    }

    $stmt->bind_param(
        'sssssssssssssssssssssss', 
        $agencia, $folio, $name, $email, $phone, $pax, $car, $pagado, $total, $balance, $pickupPlace, 
        $activity, $activityDate, $activityTime, $bbs, $crs, $bos, $shopping, $obs_int, $service, $ida, $idr, $proveedor_id
    );

    if (!$stmt->execute()) {
        throw new Exception('Error al insertar la reserva: ' . $stmt->error);
    }

    echo json_encode(['success' => true, 'message' => 'Reserva creada correctamente.']);
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
} finally {
    if (isset($stmt)) $stmt->close();
    if (isset($conn)) $conn->close();
}


?>