<?php
ini_set('display_errors', 0);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
setlocale(LC_TIME, 'es_MX.UTF-8');
date_default_timezone_set('America/Mazatlan');

$fecha = date('Y-m-d'); // El día actual

header('Content-Type: application/json; charset=utf-8');

include 'conn.php';
include 'ida.php';
// Ajustar la consulta para obtener todas las reservas del día actual

$stmt = $conn->prepare("
    SELECT DISTINCT r.*, c.img , p.empresa
    FROM reservas r
    LEFT JOIN cars c ON r.car = c.car
    LEFT JOIN proveedores p ON r.proveedor_id = p.id
    WHERE 
        (r.arrival_date = ? OR r.departure_date = ?) AND
        r.ida = ? AND
        r.status != 4
    ORDER BY r.arrival_time ASC, r.departure_pickuptime ASC
");


// Bind de la fecha del día actual para ambas condiciones
$stmt->bind_param("sss", $fecha, $fecha, $ida);

$stmt->execute();
$result = $stmt->get_result();

// Crear un array con las reservas

$reservas = array();
while ($row = $result->fetch_assoc()) {
    if($row['service'] == 'ona'){
        $row['serviceText'] = 'Llegada';
        $row['time'] = $row['arrival_time'];
        $row['airline'] = $row['arrival_airline'];
        $row['flight'] = $row['arrival_flight'];
        $row['hotel'] = $row['arrival_hotel'];
    }
    //si servicio es ond entonces service = 'Salida'
    if($row['service'] == 'ond'){
        $row['serviceText'] = 'Salida';
        $row['time'] = $row['departure_pickuptime'];
        $row['airline'] = $row['departure_airline'];
        $row['flight'] = $row['departure_flight'];
        $row['hotel'] = $row['departure_hotel'];
    }
    //si servicio es ope o tra 
    if($row['service'] == 'ope'){
        $row['serviceText'] = 'Open Service';
        $row['time'] = $row['arrival_time'];
        $row['hotel'] = $row['arrival_pickup'];
        $row['airline'] = 'N/A';
        $row['flight'] = 'N/A';

    }
    if($row['service'] == 'tra'){
        $row['serviceText'] = 'Transfer';
        $row['time'] = $row['arrival_time'];
        $row['hotel'] = $row['arrival_pickup'].' - '.$row['arrival_hotel'];
        $row['airline'] = 'N/A';
        $row['flight'] = 'N/A';

    }
    //si servicio es roa entonces nos basamos en la fecha de llegada y salida para determinar si es llegada o salida
    if($row['service'] == 'roa'){
        if($fecha <= $row['arrival_date']){
            $row['serviceText'] = 'Llegada';
            $row['time'] = $row['arrival_time'];
            $row['airline'] = $row['arrival_airline'];
            $row['flight'] = $row['arrival_flight'];
            $row['hotel'] = $row['arrival_hotel'];
        }else{
            $row['serviceText'] = 'Salida';
            $row['time'] = $row['departure_pickuptime'];
            $row['airline'] = $row['departure_airline'];
            $row['flight'] = $row['departure_flight'];
            $row['hotel'] = $row['departure_hotel'];
        }
    }
    if($row['service'] == 'trr'){
        if($fecha <= $row['arrival_date']){
            $row['serviceText'] = 'Traslado';
            $row['time'] = $row['arrival_time'];
            $row['airline'] = 'N/A';
            $row['flight'] = 'N/A';
            $row['hotel'] = $row['arrival_hotel'];
        }else{
            $row['serviceText'] = 'Traslado';
            $row['time'] = $row['departure_pickuptime'];
            $row['airline'] = $row['departure_airline'];
            $row['flight'] = $row['departure_flight'];
            $row['hotel'] = $row['departure_hotel'];
        }
    }
    $reservas[] = $row;
}


// Enviar el array de reservas en formato JSON
echo json_encode(["data" => $reservas]);

// Cerrar la conexión
$conn->close();
?>

